@extends('layouts.app')

@section('content')

<div class="page-wrapper">

    <div class="row page-titles">

        <div class="col-md-5 align-self-center">

            <h3 class="text-themecolor">{{trans('lang.order_review')}} <span class="storeTitle"></span></h3>

        </div>

        <div class="col-md-7 align-self-center">

            <ol class="breadcrumb">

                <li class="breadcrumb-item"><a href="{{url('/dashboard')}}">{{trans('lang.dashboard')}}</a></li>

                <li class="breadcrumb-item active">{{trans('lang.order_review_table')}}</li>

            </ol>

        </div>

        <div>

        </div>

    </div>



    <div class="container-fluid">

        <div class="row">

            <div class="col-12">
                    <?php if($id!=''){ ?>
                    <div class="menu-tab">
                        <ul>
                            <li >
                                <a href="{{route('vendors.view',$id)}}">{{trans('lang.tab_basic')}}</a>
                            </li>
                            <li >
                                <a href="{{route('vendors.items',$id)}}">{{trans('lang.tab_items')}}</a>
                            </li>
                            <li>
                                <a href="{{route('vendors.orders',$id)}}">{{trans('lang.tab_orders')}}</a>
                            </li>
                            <li class="active">
                                <a href="{{route('vendors.reviews',$id)}}">{{trans('lang.tab_reviews')}}</a>
                            </li>
                            <li>
                                <a href="{{route('vendors.coupons',$id)}}">{{trans('lang.tab_promos')}}</a>
                            <li>
                                <a href="{{route('vendors.payout',$id)}}">{{trans('lang.tab_payouts')}}</a>
                            </li>
                            <li>
                                <a href="{{route('users.walletstransaction',$id)}}"
                                           class="wallet_transaction">{{trans('lang.wallet_transaction')}}</a>
                            </li>
                            <li class="dine_in_future" style="display:none;">
                                <a href="{{route('vendors.booktable',$id)}}">{{trans('lang.dine_in_future')}}</a>
                            </li>
                        </ul>
                    </div>
                <?php } ?>

                <div class="card">

                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">{{trans('lang.processing')}}</div>
                        
                        </div>

                        <div class="table-responsive m-t-10 p-2">

                            <table id="example24" class="display nowrap table table-hover table-striped table-bordered table table-striped" cellspacing="0" width="100%">

                                <thead>

                                    <tr>

                                        <th>{{trans('lang.order_id')}}</th>

                                        <th class="address-list">{{ trans('lang.order_review')}}</th>

                                        <th>{{ trans('lang.item_review_rate')}}</th>

                                        <th>{{ trans('lang.item_review_user_id')}}</th>

                                        <?php if($id ==''){ ?>
                                            <th>{{trans('lang.vendor')}}</th>
                                        <?php }?>

                                        <th>{{trans('lang.actions')}}</th>

                                    </tr>

                                </thead>

                                <tbody id="append_list1">

                                </tbody>

                            </table>

                        </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>
</div>

@endsection

@section('scripts')

<script type="text/javascript">

 var database = firebase.firestore();

    var offest=1;
    var pagesize=10;
    var pagesizes = 0;
    var end = null;
    var endarray=[];
    var start = null;
    var user_number = [];
    var vendorID="{{$id}}";                                      
    <?php if($id!=''){ ?>
    var wallet_route = "{{route('users.walletstransaction','id')}}";
    $(".wallet_transaction").attr("href", wallet_route.replace('id', 'storeID='+vendorID));
    var ref = database.collection('items_review').where('VendorId','==','<?php echo $id; ?>');
        getStoreNameFunction('<?php echo $id; ?>');
    <?php }else{ ?>
    var ref = database.collection('items_review');
    <?php } ?>

    var append_list = '';

$(document).ready(function() {

    $(document.body).on('click', '.redirecttopage' ,function(){
        var url=$(this).attr('data-url');
        window.location.href = url;
    });

    jQuery("#data-table_processing").show();
    append_list = document.getElementById('append_list1');
    append_list.innerHTML='';
    pagesizes = getCookie('pagesizes');

    if(pagesizes !=0){

        $('.pageSize option[value='+pagesizes+']').attr('selected','selected');
            ref.limit(pagesizes).get().then( async function(snapshots){
            html='';
            html=buildHTML(snapshots);
            jQuery("#data-table_processing").hide();
            if(html!=''){
                append_list.innerHTML=html;
                start = snapshots.docs[snapshots.docs.length - 1];
                endarray.push(snapshots.docs[0]);
                if(snapshots.docs.length<pagesizes){
                    jQuery("#data-table_paginate").hide();
                }
            }
            $('#example24').DataTable({
                
                order: [],
                columnDefs: [
                    {orderable: false, targets: [1, 2, 4]},
                ],
                "language": {
                    "zeroRecords": "{{trans("lang.no_record_found")}}",
                    "emptyTable": "{{trans("lang.no_record_found")}}"
                },
                responsive: true,
            });
        });
    }else{

    ref.limit(pagesize).get().then( async function(snapshots){
        html='';
        html=buildHTML(snapshots);
        jQuery("#data-table_processing").hide();
            if(html!=''){
                append_list.innerHTML=html;
                start = snapshots.docs[snapshots.docs.length - 1];
                endarray.push(snapshots.docs[0]);
                if(snapshots.docs.length<pagesize){
                    jQuery("#data-table_paginate").hide();
                }
            }
            $('#example24').DataTable({
                
                order: [],
                columnDefs: [
                    {orderable: false, targets: [0, 1, 2, 4]},
                ],
                "language": {
                    "zeroRecords": "{{trans("lang.no_record_found")}}",
                    "emptyTable": "{{trans("lang.no_record_found")}}"
                },
                responsive: true,
            });
        });
    }
});

function getStoreNameFunction(vendorId){
    var vendorName = '';
        database.collection('vendors').where('id', '==', vendorId).get().then(function (snapshots) {
        var vendorData = snapshots.docs[0].data();
        vendorName = vendorData.title;
        $(".storeTitle").text(' - '+vendorName);

        if(vendorData.dine_in_active==true){
            $(".dine_in_future").show();
        }

    });
    return vendorName;
}

   function buildHTML(snapshots){
    var html='';
    var alldata=[];
    var number= [];
    snapshots.docs.forEach((listval) => {
        var datas=listval.data();
        datas.id=listval.id;
        alldata.push(datas);
    });

    var count = 0;
    alldata.forEach((listval) => {

            var val=listval;
            html=html+'<tr>';
            newdate='';
            var reviewId = val.Id;
            var route1 =  '{{route("orderReview.edit",":id")}}';
            route1 = route1.replace(':id', reviewId);

            var route_orderid =  '{{route("orders.review",":oid")}}';
            route_orderid = route_orderid.replace(':oid', val.orderid);

            var route_user =  '{{route("users.edit",":id")}}';
            route_user = route_user.replace(':id', val.CustomerId);

            var route_vendors =  '{{route("vendors.view",":id")}}';
            route_vendors = route_vendors.replace(':id', val.VendorId);

            <?php if($id!=''){ ?>
                route1 =route1+'?eid={{$id}}';
                route_orderid =route_orderid+'?eid={{$id}}';
            <?php }?>

            html=html+'<td data-url="'+route_orderid+'" class="redirecttopage">'+val.orderid+'</td>';

            html=html+'<td class="address-list">'+val.comment+'</td>';

            
            html=html + '<td><ul class="rating" data-rating="'+val.rating+'"><li class="rating__item"></li><li class="rating__item"></li><li class="rating__item"></li><li class="rating__item"></li><li class="rating__item"></li></ul></td>';

            const user_name=userName(val.CustomerId);
            html=html+'<td class="name_'+val.CustomerId+' redirecttopage" data-url="'+route_user+'"></td>';

            <?php if($id ==''){ ?>
                const vendor_name = vendorName(val.VendorId);
                html=html+'<td class="item_'+val.VendorId+' redirecttopage" data-url="'+route_vendors+'"></td>';
            <?php }?>


            html=html+'<td class="action-btn"><a href="'+route1+'"><i class="fa fa-edit"></i></a><a id="'+val.Id+'" name="item-review-delete" class="do_not_delete" href="javascript:void(0)"><i class="fa fa-trash"></i></a></td>';

            html=html+'</tr>';
            count =count +1;
        });
        return html;
}

function prev(){
    
    if(endarray.length==1){
        return false;
    }
    
    end=endarray[endarray.length-2];

  if(end!=undefined || end!=null){
    jQuery("#data-table_processing").show();
            if(jQuery("#selected_search").val()=='order_id' && jQuery("#search").val().trim()!=''){

            listener=ref.orderBy('Id').limit(pagesize).startAt(jQuery("#search").val()).endAt(jQuery("#search").val()+'\uf8ff').startAt(end).get();

        }else{
            listener = ref.startAt(end).limit(pagesize).get();
        }

        listener.then((snapshots) => {
        html='';
        html=buildHTML(snapshots);
        jQuery("#data-table_processing").hide();
        if(html!=''){
            append_list.innerHTML=html;
            start = snapshots.docs[snapshots.docs.length - 1];
            endarray.splice(endarray.indexOf(endarray[endarray.length-1]),1);

            if(snapshots.docs.length < pagesize){

                jQuery("#users_table_previous_btn").hide();
            }

        }
    });
  }
}

function next(){

  if(start!=undefined || start!=null){

    jQuery("#data-table_processing").hide();

        if(jQuery("#selected_search").val()=='order_id' && jQuery("#search").val().trim()!=''){

            listener=ref.orderBy('Id').limit(pagesize).startAt(jQuery("#search").val()).endAt(jQuery("#search").val()+'\uf8ff').startAfter(start).get();

            }else{
            listener = ref.startAfter(start).limit(pagesize).get();
        }
        listener.then((snapshots) => {

            html='';
            html=buildHTML(snapshots);
            jQuery("#data-table_processing").hide();
            if(html!=''){
                append_list.innerHTML=html;
                start = snapshots.docs[snapshots.docs.length - 1];

                if(endarray.indexOf(snapshots.docs[0])!=-1){
                    endarray.splice(endarray.indexOf(snapshots.docs[0]),1);
                }
                endarray.push(snapshots.docs[0]);
            }
        });
    }
}
function clickpage(value) {
        setCookie('pagesizes', value, 30);
        location.reload();
    }

async function userName(userID) {
    var userName='';
    await database.collection('users').where("id","==",userID).get().then( async function(snapshotss){

        if(snapshotss.docs[0]){
            var user = snapshotss.docs[0].data();
            userName = user.firstName+" "+user.lastName;
            jQuery(".name_"+userID).html(userName);

        }else{
            jQuery(".name_"+userID).html('');

        }
    });
    return userName;
}

async function vendorName(vendorID) {
    var vendorName ='';
    await database.collection('vendors').where("id","==",vendorID).get().then( async function(snapshotss){

                if(snapshotss.docs[0]){
                    var vendor = snapshotss.docs[0].data();
                    vendorName = vendor.title;

                    jQuery(".item_"+vendorID).html(vendorName);

                }else{
                    jQuery(".item_"+vendorID).html('');

                }
    });
    return vendorName;
}

$(document).on("click","a[name='item-review-delete']", function (e) {
    var id = this.id;
     database.collection('items_review').doc(id).delete().then(function(result) {
        window.location.href = '{{ route("orderReview")}}';
    })
});

</script>

@endsection
